// File: /docs/03-contracts/generated/Contract—ui-input.md

# Contract — ui-input

## Header
Component ID: ui-input  
Category (Prefix): ui  
Variants: text | email | password | number | search  

---

## Intent
Capture a single line of user input with validation feedback support.

---

## Rules

### Must
- Accept a single-line user value
- Support label, placeholder, and helper text
- Support validation feedback (error only)
- Maintain accessible focus and keyboard behaviour
- Use semantic colour tokens only
- Preserve value on re-render unless explicitly reset by the application

### Must Not
- Handle multi-line input (use ui-textarea instead)
- Encode business rules or submission logic
- Trigger navigation or form submission by itself
- Be used as a layout or container element
- Manage async data fetching internally
- Manage async state
- Store internal value state
- Perform validation logic
- Infer validation outcome from user interaction alone

### Search Variant Rules
For variant `search`:
- MUST NOT include filtering logic
- MUST NOT perform queries
- MUST NOT debounce internally

---

## Props / API

### Props (Design)
- variant (text | email | password | number | search)
- size (sm | md | lg)
- label (optional)
- placeholder (optional)
- helperText (optional)
- errorText (optional)
- required (boolean)
- disabled (boolean)
- leadingIcon (optional)
- trailingIcon (optional)

### Props (Code)
ts
export interface UiInputProps {
  /** Defines the semantic intent of the input */
  variant?: "text" | "email" | "password" | "number" | "search";

  /** Visual size only (no behavioral impact) */
  size?: "sm" | "md" | "lg";

  /** Controlled value */
  value?: string;

  /** Uncontrolled initial value */
  defaultValue?: string;

  /** Placeholder text */
  placeholder?: string;

  /** Visible label text */
  label?: string;

  /** Helper text shown below the input */
  helperText?: string;

  /** Error message (presence triggers error state) */
  error?: string;

  /** Native input attributes */
  name?: string;
  id?: string;
  autoComplete?: string;

  /** HTML-required attribute */
  required?: boolean;

  /** Disables interaction and removes from tab order */
  disabled?: boolean;

  /** Optional leading icon */
  leadingIcon?: React.ReactNode | IconRef;

  /** Optional trailing icon */
  trailingIcon?: React.ReactNode | IconRef;

  /** Emits user intent only; does not validate or mutate canonical state */
  onChange?: (value: string) => void;

  /** Focus and blur events (visual only) */
  onFocus?: () => void;
  onBlur?: () => void;
}

---

## States

### Primary States (Application-owned)
- default
- error
- disabled

### Interaction States (Visual-only)
- focus

### Rules:
- “Filled” is a derived visual condition, not a state
- Success is not a valid input state
- Success feedback is owned by the form or flow, not the input

---

## Slots
- label
- helper text
- error message
- leading icon
- trailing icon

### Slot Rules:
- Slots are structural only
- Slots must not affect input height or layout
- Slots must not encode behaviour

---

## Usage

### Use When
- Capturing short user input
- Validating form fields
- Collecting credentials or structured data
- Supporting controlled or uncontrolled form patterns

### Avoid When
- Collecting multi-line text (use ui-textarea)
- Displaying read-only data
- Handling complex interactions
- Representing selections (use ui-select, ui-checkbox, ui-radio)

---

## Code Hint
Primary Code Hint: `ui-input → Input`

---

## Naming Rules
Format: `[prefix]-[domain]-[role]--[variant]`  
Example: `ui-input-form--email`

---

# Component Preview Area

## Component Identity
Component ID: ui-input  
Category (Prefix): ui  
Component Type: Atomic  

---

## Canonical Component Reference
Figma Component: `UI / Forms / Input`

### Single Source of Truth
- This component definition is canonical
- Local copies or visual overrides are not permitted
- All variants and states must be implemented within this component

---

## Variant Matrix (As Implemented)

### Variants
- text
- email
- password
- number
- search

### Sizes
- sm
- md
- lg

### States
- default
- focus
- error
- disabled

Rules:
- No visual-only variants outside this list
- No variant nesting beyond these axes
- Variant combinations must be valid and intentional

---

## Token Dependency Contract

### Consumes Tokens
- color.bg.*
- color.text.*
- color.border.*
- space.*
- radius.*
- typography.*

### Token Rules
- No raw values allowed
- No component-specific colors
- No local overrides

---

## Layout & Structure Rules

### Layout Model
- Single-line input field
- Optional leading and trailing icon
- Inline helper text and error text

### Spacing
- Padding and gap are token-driven
- Height is controlled by size variant only
- Width is container-controlled

---

## State → Visual Mapping

### Default
- Neutral border
- Base text colour

### Focus
- Visible focus ring
- Primary border or focus indicator

### Error
- Danger border colour
- Error text visible

### Disabled
- Reduced opacity
- No pointer or keyboard interaction

---

## Accessibility Guarantees
- Keyboard focusable
- Visible focus indicator
- Label association required
- Error text linked via `aria-describedby`
- Meets WCAG AA contrast

---

## Structural Slots

### Slots
- leadingIcon (optional)
- trailingIcon (optional)

### Slot Rules:
- Icons inherit current text colour
- Slots must not affect input height
- Icons must not replace text input affordance

---

## Naming Lock (Final)

### Allowed Names
- ui-input

### Disallowed
- input
- ui-text-input
- form-input
- input-primary

---

## Component Identity

### Contract State
Locked

### Behavioral Contract
- Standalone atomic component

### Changes Allowed
- Token updates (global only)
- Visual refinements without intent change

### Changes Not Allowed
- New variants
- Behavioural changes
- Renaming